/*-
 * Copyright (c) 2016 Eric McCorkle
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/11/stand/efi/include/efizfs.h 344371 2019-02-20 18:34:20Z kevans $
 */

#include <stdint.h>
#include <stdbool.h>

#ifndef _EFIZFS_H_
#define _EFIZFS_H_

#ifdef EFI_ZFS_BOOT
typedef STAILQ_HEAD(zfsinfo_list, zfsinfo) zfsinfo_list_t;

typedef struct zfsinfo
{
	STAILQ_ENTRY(zfsinfo) zi_link;
	EFI_HANDLE zi_handle;
        uint64_t zi_pool_guid;
} zfsinfo_t;

extern uint64_t pool_guid;

void efi_zfs_probe(void);
EFI_HANDLE efizfs_get_handle_by_guid(uint64_t);
bool efizfs_get_guid_by_handle(EFI_HANDLE, uint64_t *);
zfsinfo_list_t *efizfs_get_zfsinfo_list(void);
void efizfs_set_preferred(EFI_HANDLE);

#endif

#endif
